# To the extent possible under law, Eric Muller has waived all
# copyright and related or neighboring rights to the efele.net/tz maps
# (comprising the shapefiles, the web pages describing them and the scripts
# and data used to build them. This work is published from the United States of
# America.
#
# See http://creativecommons.org/publicdomain/zero/1.0/ for more details.


# hp2pgsql -W LATIN1 -d -g geom -I municipal | \
#   psql -L municipal.log -q

psql <<EOF

SELECT DropGeometryColumn('','temp_tz','geom');
DROP TABLE temp_tz;

CREATE TABLE temp_tz (tzid text, nom_ent text, nom_mun text);
SELECT AddGeometryColumn('','temp_tz','geom','0','POLYGON',2);

INSERT INTO temp_tz (tzid, geom, nom_ent, nom_mun)
SELECT '', (ST_Dump(geom)).geom, nom_ent, nom_mun
FROM municipal;


UPDATE temp_tz SET tzid = 'America/Cancun'
WHERE nom_ent = 'Quintana Roo';

UPDATE temp_tz SET tzid = 'America/Merida'
WHERE nom_ent = 'Campeche'
   OR nom_ent = 'Yucatán';

UPDATE temp_tz SET tzid = 'America/Matamoros'
WHERE nom_ent = 'Coahuila de Zaragoza'
  AND (   nom_mun = 'Ocampo'
       OR nom_mun = 'Acuña'
       OR nom_mun = 'Zaragoza'
       OR nom_mun = 'Jiménez'
       OR nom_mun = 'Piedras Negras'
       OR nom_mun = 'Nava'
       OR nom_mun = 'Guerrero'
       OR nom_mun = 'Hidalgo');

UPDATE temp_tz SET tzid = 'America/Matamoros'
WHERE nom_ent = 'Nuevo León'
  AND (   nom_mun = 'Anáhuac'
       OR nom_mun = 'Los Aldamas');


UPDATE temp_tz SET tzid = 'America/Matamoros'
WHERE nom_ent = 'Tamaulipas'
  AND (   nom_mun = 'Nuevo Laredo'
       OR nom_mun = 'Guerrero'
       OR nom_mun = 'Mier'
       OR nom_mun = 'Miguel Alemán'
       OR nom_mun = 'Camargo'
       OR nom_mun = 'Gustavo Díaz Ordaz'
       OR nom_mun = 'Reynosa'
       OR nom_mun = 'Río Bravo'
       OR nom_mun = 'Valle Hermoso'
       OR nom_mun = 'Matamoros');

UPDATE temp_tz SET tzid = 'America/Monterrey'
WHERE tzid = ''
  AND (   nom_ent = 'Durango'
       OR nom_ent = 'Coahuila de Zaragoza'
       OR nom_ent = 'Nuevo León'
       OR nom_ent = 'Tamaulipas');

UPDATE temp_tz SET tzid = 'America/Ojinaga'
WHERE nom_ent = 'Chihuahua'
  AND (   nom_mun = 'Janos'
       OR nom_mun = 'Ascensión'
       OR nom_mun = 'Juárez'
       OR nom_mun = 'Guadalupe'
       OR nom_mun = 'Praxedis G. Guerrero'
       OR nom_mun = 'Coyame del Sotol'
       OR nom_mun = 'Ojinaga'
       OR nom_mun = 'Manuel Benavides');

UPDATE temp_tz SET tzid = 'America/Chihuahua'
WHERE tzid = '' 
  AND nom_ent = 'Chihuahua';

UPDATE temp_tz SET tzid = 'America/Hermosillo'
WHERE nom_ent = 'Sonora';

UPDATE temp_tz SET tzid = 'America/Bahia_Banderas'
WHERE (nom_ent = 'Nayarit' and nom_mun = 'Bahía de Banderas');

UPDATE temp_tz SET tzid = 'America/Mazatlan'
WHERE tzid = ''
  AND (  nom_ent = 'Mazatlán'
       OR nom_ent = 'Sinaloa'
       OR nom_ent = 'Baja California Sur'
       OR nom_ent = 'Nayarit');


UPDATE temp_tz SET tzid = 'America/Tijuana'
WHERE nom_ent = 'Baja California';

UPDATE temp_tz SET tzid = 'America/Mexico_City'
WHERE tzid = '';

--- dissolve on the tzid attribute

SELECT DropGeometryColumn('','tz_mexico','geom');
DROP TABLE tz_mexico;

CREATE TABLE tz_mexico (tzid text);
SELECT AddGeometryColumn('','tz_mexico','geom','0','POLYGON',2);

INSERT INTO tz_mexico (tzid, geom)
  SELECT tzid, geom FROM (
    SELECT tzid, (ST_Dump (geom)).geom AS geom FROM (
      SELECT tzid, ST_union (geom) AS geom
      FROM temp_tz
      GROUP BY tzid)
    as x)
  as y;


SELECT DropGeometryColumn('','temp_tz', 'geom');
DROP TABLE temp_tz;

EOF

rm -fr tz_mexico.{dbf,prj,shp,shx}

pgsql2shp -g geom -f tz_mexico geo tz_mexico

cp municipal.prj tz_mexico.prj



