# To the extent possible under law, Eric Muller has waived all
# copyright and related or neighboring rights to the efele.net/tz maps
# (comprising the shapefiles, the web pages describing them and the scripts
# and data used to build them. This work is published from the United States of
# America.
#
# See http://creativecommons.org/publicdomain/zero/1.0/ for more details.

for f in pbd90 tbd90; do

  rm -fr conv
  mkdir conv

  Import71.exe ${f}.e00 conv/adf /T

  ogr2ogr \
    -s_srs '+proj=lcc +lat_1=25 +lat_2=47 +lat_0=10 +lon_0=110 +ellps=clrk66 +units=m +no_defs' \
    -t_srs '+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs' \
    -f "ESRI Shapefile" conv/shp conv/adf

  for e in dbf prj shp shx; do
    cp conv/shp/PAL.${e} cd_${f}.${e};
  done

  rm -fr conv

  shp2pgsql -s 4326 -S -d -g geom -i -I cd_$f cd_$f | \
  sed -e "s_\\\'_''_g" | \
  psql -L cd_$f.log -q


done


psql.exe -e <<EOF

drop table cd2tz;
create table cd2tz (gid serial primary key,
                    prov_nm text, 
                    cnty_nm text,
                    code_90 integer,
                    tzid text);

EOF

psql.exe -c 'copy cd2tz (prov_nm, cnty_nm, code_90, tzid) from STDIN  CSV HEADER;' < cd2tz.csv

psql.exe -e <<EOF

select DropGeometryColumn ('', 'tz_china', 'geom');

drop table tz_china;

create table tz_china (gid serial primary key,
                       tzid text);

select AddGeometryColumn ('', 'tz_china', 'geom', '4326', 'POLYGON', 2);

INSERT INTO tz_china (tzid, geom) 
  SELECT tzid, h as geom FROM
    (SELECT tzid, (ST_Dump (geom)).geom AS h FROM 
       (SELECT tzid, ST_Union (geom) as geom
        FROM cd_tbd90, cd2tz 
        WHERE cd_tbd90.code_90 = cd2tz.code_90
        GROUP BY tzid)
       AS x)
    AS y;

EOF


pgsql2shp -g geom -f tz_china geo tz_china


#---- for the snapshot

rm -fr tz_china_lcc.*

ogr2ogr \
    -s_srs '+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs' \
    -t_srs '+proj=lcc +lat_1=25 +lat_2=47 +lat_0=10 +lon_0=110 +ellps=clrk66 +units=m +no_defs' \
    tz_china_lcc.shp tz_china.shp

    
