# To the extent possible under law, Eric Muller has waived all
# copyright and related or neighboring rights to the efele.net/tz maps
# (comprising the shapefiles, the web pages describing them and the scripts
# and data used to build them. This work is published from the United States of
# America.
#
# See http://creativecommons.org/publicdomain/zero/1.0/ for more details.

psql.exe <<EOF

SELECT DropGeometryColumn ('', 'tz_canada_mask', 'geom');
DROP table tz_canada_mask;

CREATE TABLE tz_canada_mask (fips4 text, tzid  text);
SELECT AddGeometryColumn('','tz_canada_mask','geom','4326','POLYGON',2);

EOF


for p in 01 02 03 04 05 07 08 09 10 11 12 13 14; do 
  shp2pgsql -s 4326 -S -a -g geom -i tz_canada_${p} tz_canada_mask | \
  psql
done

psql.exe <<EOF

SELECT DropGeometryColumn ('', 'temp_tz', 'geom');
DROP TABLE temp_tz;

CREATE TABLE temp_tz (tzid  text,
                      fips2 varchar(2),
                      fips4 varchar(4));
SELECT AddGeometryColumn ('', 'temp_tz', 'geom', '4326', 'POLYGON', 2);

INSERT INTO temp_tz (geom, tzid, fips2, fips4)
SELECT geom (ST_Dump (ST_Intersection (fips10s.geom, tz_canada_mask.geom))), 
       tz_canada_mask.tzid, fips10s.fips2, fips10s.fips4
FROM fips10s, tz_canada_mask
WHERE fips10s.fips4 = tz_canada_mask.fips4
  AND ST_intersects (fips10s.geom, tz_canada_mask.geom);


SELECT DropGeometryColumn ('', 'tz_canada', 'geom');
DROP TABLE tz_canada;

CREATE TABLE tz_canada (tzid text);
SELECT AddGeometryColumn ('tz_canada', 'geom', 4326, 'GEOMETRY', 2);


-- dissolve on tzid

INSERT INTO tz_canada (tzid, geom)
  SELECT tzid, h AS geom FROM (
    SELECT tzid AS tzid, (ST_Dump (g)).geom AS h FROM (
      SELECT tzid AS tzid, ST_union (geom) AS g
      FROM temp_tz
      GROUP by tzid)
    as x)
  as y;


SELECT DropGeometryColumn ('', 'temp_tz', 'geom');
DROP TABLE temp_tz;

EOF

pgsql2shp -g geom -f tz_canada geo tz_canada


#----- for the snapshot

rm -fr tz_canada_utm13.{shp,shx,dbf,prj}

ogr2ogr -s_srs '+proj=latlong' -t_srs '+proj=utm +zone=13 +units=m' \
    tz_canada_utm13.shp tz_canada.shp

